/*  Sucht alle möglichen Arbeitsplätze auf dem der gegebene AG ausgeführt werden darf und gibt die IDs der möglichen
    Arbeitsplätze zurück.

    Zuerst wird geprüft, ob ein konkreter Arbeitsplatz im Arbeitsgang (Spalte ab2.a2_ksap) vorgegeben wurde. Ansonsten sind alle
    Arbeitsplätze der mit dem AG verknüpften Kostenstelle erlaubt.
    Zusätzlich werden die alternativen Arbeitsplätze des entsprechenden AG aus der ASK herangezogen.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__resources__ksb_id__by__a2_ks_ksap__get', _commit => true ); -- Alter Funktionsname
--
SELECT tsystem.function__drop_by_regex( 'ab2__find_possible_workplaces', 'scheduling', _commit => true ); -- alter Funktionsname
SELECT tsystem.function__drop_by_regex( 'ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( _ab2 ab2 ) returns int[] AS $$
  DECLARE
      _result int[];
      _ab2_record record;
  BEGIN

    -- first element is always the workplace defined in ab2
    _ab2_record := _ab2;

    IF (
           _ab2_record.a2_ksap IS NULL
        OR _ab2_record.a2_ksap = ''
    ) THEN

        -- append all workplaces of given pool ksv
        _result :=
             _result
          || ( SELECT array_agg( ksb_id ) FROM ksvba WHERE ksb_ks_abt = _ab2_record.a2_ks )
        ;

    ELSE

        -- append single workplace
        _result :=
               _result
            || ( SELECT array_agg( ksb_id ) FROM ksvba WHERE ksb_ks_abt = _ab2_record.a2_ks AND ksb_ks_ba_babz = _ab2_record.a2_ksap )
        ;

    END IF;

    -- fetch given alternatives
    _result := _result || array_agg( ksb_id )
                 FROM op2
                 JOIN op2ksa ON o2_id = o2ks_o2_id
                 JOIN ksvba ON o2ks_ks_id = ksb_ks_id AND ( o2ks_ksap = ksb_ks_ba_babz OR o2ks_ksap IS NULL OR o2ks_ksap = '')
                WHERE o2_id = _ab2.a2_o2_id;

    -- unique array
    _result := array_agg( distinct ids ) FROM unnest( _result ) t(ids);

    RETURN _result;

  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( _ab2_id integer ) returns int[]
    AS $$
      SELECT scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( ab2 ) FROM ab2 WHERE a2_id = _ab2_id;
    $$ LANGUAGE sql STABLE PARALLEL SAFE;